#include <Wire.h> 
#include <LiquidCrystal_I2C.h>

// Set the LCD address to 0x27 (PCF8574 address 0x20-0x27) for a 20 chars and 4 line display 
// Set the LCD address to 0x3F (PCF8574A address 0x38-0x3F) for a 20 chars and 4 line display
LiquidCrystal_I2C lcd(0x27, 20, 4);

void setup() {
  // initialize the LCD
  lcd.begin();

  // Turn on the blacklight and print a message.
  lcd.backlight();
  
  // Print a message to the LCD.
  lcd.print("LCD 20 x 4 I2C");
  lcd.setCursor(0, 1);
  lcd.print("www.etteam.com");
  lcd.setCursor(0, 2);
  lcd.print("ETT Co.,Ltd.");
  lcd.setCursor(0, 3);
  lcd.print("Thailand");
}

void loop() {
  lcd.backlight();
  delay(1000);
  lcd.noBacklight();
  delay(1000);
}

